﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bcm-data-exports/BCMDataExportsRequest.h>
#include <aws/bcm-data-exports/BCMDataExports_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace BCMDataExports {
namespace Model {

/**
 */
class GetExecutionRequest : public BCMDataExportsRequest {
 public:
  AWS_BCMDATAEXPORTS_API GetExecutionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetExecution"; }

  AWS_BCMDATAEXPORTS_API Aws::String SerializePayload() const override;

  AWS_BCMDATAEXPORTS_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The ID for this specific execution.</p>
   */
  inline const Aws::String& GetExecutionId() const { return m_executionId; }
  inline bool ExecutionIdHasBeenSet() const { return m_executionIdHasBeenSet; }
  template <typename ExecutionIdT = Aws::String>
  void SetExecutionId(ExecutionIdT&& value) {
    m_executionIdHasBeenSet = true;
    m_executionId = std::forward<ExecutionIdT>(value);
  }
  template <typename ExecutionIdT = Aws::String>
  GetExecutionRequest& WithExecutionId(ExecutionIdT&& value) {
    SetExecutionId(std::forward<ExecutionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the Export object that generated this
   * specific execution.</p>
   */
  inline const Aws::String& GetExportArn() const { return m_exportArn; }
  inline bool ExportArnHasBeenSet() const { return m_exportArnHasBeenSet; }
  template <typename ExportArnT = Aws::String>
  void SetExportArn(ExportArnT&& value) {
    m_exportArnHasBeenSet = true;
    m_exportArn = std::forward<ExportArnT>(value);
  }
  template <typename ExportArnT = Aws::String>
  GetExecutionRequest& WithExportArn(ExportArnT&& value) {
    SetExportArn(std::forward<ExportArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_executionId;

  Aws::String m_exportArn;
  bool m_executionIdHasBeenSet = false;
  bool m_exportArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace BCMDataExports
}  // namespace Aws
