/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQAgentI;

class AQMessagePropertiesI
implements AQMessageProperties {
    private int attrAttempts = -1;
    private String attrCorrelation = null;
    private int attrDelay = 0;
    private Timestamp attrEnqTime = null;
    private String attrExceptionQueue = null;
    private int attrExpiration = -1;
    private AQMessageProperties.MessageState attrMsgState = null;
    private int attrPriority = 0;
    private AQAgentI[] attrRecipientList = null;
    private AQAgentI attrSenderId = null;
    private String attrTransactionGroup = null;
    private byte[] attrPreviousQueueMsgId = null;
    private AQMessageProperties.DeliveryMode deliveryMode = null;
    private int attrShardNum = -1;

    AQMessagePropertiesI() {
    }

    @Override
    public int getDequeueAttemptsCount() {
        return this.attrAttempts;
    }

    @Override
    public void setCorrelation(String correlation) throws SQLException {
        this.attrCorrelation = correlation;
    }

    @Override
    public String getCorrelation() {
        return this.attrCorrelation;
    }

    @Override
    public void setDelay(int delay) throws SQLException {
        this.attrDelay = delay;
    }

    @Override
    public int getDelay() {
        return this.attrDelay;
    }

    @Override
    public Timestamp getEnqueueTime() {
        return this.attrEnqTime;
    }

    @Override
    public void setExceptionQueue(String exceptionQueue) throws SQLException {
        this.attrExceptionQueue = exceptionQueue;
    }

    @Override
    public String getExceptionQueue() {
        return this.attrExceptionQueue;
    }

    @Override
    public void setExpiration(int seconds) throws SQLException {
        this.attrExpiration = seconds;
    }

    @Override
    public int getExpiration() {
        return this.attrExpiration;
    }

    @Override
    public AQMessageProperties.MessageState getState() {
        return this.attrMsgState;
    }

    @Override
    public void setPriority(int priority) throws SQLException {
        this.attrPriority = priority;
    }

    @Override
    public int getPriority() {
        return this.attrPriority;
    }

    @Override
    public void setShardNum(int shardNum) throws SQLException {
        this.attrShardNum = shardNum;
    }

    @Override
    public int getShardNum() {
        return this.attrShardNum;
    }

    @Override
    public void setRecipientList(AQAgent[] agents) throws SQLException {
        if (agents == null) {
            this.attrRecipientList = null;
        } else {
            this.attrRecipientList = new AQAgentI[agents.length];
            for (int i = 0; i < agents.length; ++i) {
                this.attrRecipientList[i] = (AQAgentI)agents[i];
            }
        }
    }

    @Override
    public AQAgent[] getRecipientList() {
        return this.attrRecipientList;
    }

    @Override
    public void setSender(AQAgent sender) throws SQLException {
        this.attrSenderId = (AQAgentI)sender;
    }

    @Override
    public AQAgent getSender() {
        return this.attrSenderId;
    }

    @Override
    public String getTransactionGroup() {
        return this.attrTransactionGroup;
    }

    void setTransactionGroup(String _txn) {
        this.attrTransactionGroup = _txn;
    }

    void setPreviousQueueMessageId(byte[] msgId) {
        this.attrPreviousQueueMsgId = msgId;
    }

    @Override
    public byte[] getPreviousQueueMessageId() {
        return this.attrPreviousQueueMsgId;
    }

    @Override
    public AQMessageProperties.DeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    void setDeliveryMode(AQMessageProperties.DeliveryMode _deliveryMode) {
        this.deliveryMode = _deliveryMode;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Correlation             : " + this.getCorrelation() + "\n");
        Timestamp enqTime = this.getEnqueueTime();
        if (enqTime != null) {
            sb.append("Enqueue time            : " + enqTime + "\n");
        }
        sb.append("Exception Queue         : " + this.getExceptionQueue() + "\n");
        sb.append("Sender                  : (" + this.getSender() + ")\n");
        int deqAttempts = this.getDequeueAttemptsCount();
        if (deqAttempts != -1) {
            sb.append("Attempts                : " + deqAttempts + "\n");
        }
        sb.append("Delay                   : " + this.getDelay() + "\n");
        sb.append("Expiration              : " + this.getExpiration() + "\n");
        AQMessageProperties.MessageState state = this.getState();
        if (state != null) {
            sb.append("State                   : " + state + "\n");
        }
        sb.append("Priority                : " + this.getPriority() + "\n");
        AQMessageProperties.DeliveryMode dmode = this.getDeliveryMode();
        if (dmode != null) {
            sb.append("Delivery Mode           : " + dmode + "\n");
        }
        sb.append("Recipient List          : {");
        AQAgent[] rec = this.getRecipientList();
        if (rec != null) {
            for (int i = 0; i < rec.length; ++i) {
                sb.append(rec[i]);
                if (i == rec.length - 1) continue;
                sb.append("; ");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    void setAttempts(int _attrAttempts) throws SQLException {
        this.attrAttempts = _attrAttempts;
    }

    void setEnqueueTime(Timestamp _attrEnqTime) throws SQLException {
        this.attrEnqTime = _attrEnqTime;
    }

    void setMessageState(AQMessageProperties.MessageState _attrMsgState) throws SQLException {
        this.attrMsgState = _attrMsgState;
    }
}

